/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.curses;

import com.majruszsenchantments.Registries;
import com.mlib.EquipmentSlots;
import com.mlib.config.BooleanConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.EffectConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.contexts.OnEntityTick;
import com.mlib.contexts.OnPlayerInteract;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.effects.ParticleHandler;
import com.mlib.enchantments.CustomEnchantment;
import com.mlib.levels.LevelHelper;
import com.mlib.math.AnyPos;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class VampirismCurse
extends CustomEnchantment {
    public VampirismCurse() {
        this.rarity(Enchantment.Rarity.RARE).category(EnchantmentCategory.ARMOR).slots(EquipmentSlots.ARMOR).curse().minLevelCost(level -> 10).maxLevelCost(level -> 50);
    }

    @AutoInstance
    public static class Handler {
        final EffectConfig weakness = new EffectConfig(MobEffects.f_19613_, 0, 20.0).stackable(120.0);
        final EffectConfig hunger = new EffectConfig(MobEffects.f_19612_, 0, 20.0).stackable(120.0);
        final DoubleConfig fireDuration = new DoubleConfig(5.0, new Range((Number)1.0, (Number)60.0));
        final BooleanConfig scalesWithLevel = new BooleanConfig(true);
        final Supplier<VampirismCurse> enchantment = Registries.VAMPIRISM;

        public Handler() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.CURSE).name("Vampirism").comment("Weakens and ignites the player when in daylight, but makes Leech enchantment stronger.");
            OnEnchantmentAvailabilityCheck.listen((Consumer)OnEnchantmentAvailabilityCheck.ENABLE).addCondition(OnEnchantmentAvailabilityCheck.is(this.enchantment)).addCondition(OnEnchantmentAvailabilityCheck.excludable()).insertTo(group);
            OnEntityTick.listen(this::applyDebuffs).addCondition(Condition.cooldown((double)2.0, (Dist)Dist.DEDICATED_SERVER).configurable(false)).addCondition(Condition.hasEnchantment(this.enchantment, data -> data.entity)).addCondition(Condition.isServer()).addCondition(Condition.predicate(data -> LevelHelper.isEntityOutside((Entity)data.entity) && LevelHelper.isDayAt((Entity)data.entity))).addConfig((IConfigurable)this.weakness.name("Weakness")).addConfig((IConfigurable)this.hunger.name("Hunger")).addConfig((IConfigurable)this.fireDuration.name("fire_duration").comment("Time the player will be set on fire in seconds per enchantment level.")).addConfig((IConfigurable)this.scalesWithLevel.name("scales_with_level").comment("Determines whether effects should be stronger with more cursed items equipped.")).insertTo(group);
            OnEntityTick.listen(this::spawnParticles).addCondition(Condition.cooldown((double)0.2, (Dist)Dist.DEDICATED_SERVER).configurable(false)).addCondition(Condition.hasEnchantment(this.enchantment, data -> data.entity)).addCondition(Condition.isServer()).addCondition(Condition.predicate(data -> LevelHelper.isEntityOutside((Entity)data.entity) && LevelHelper.isDayAt((Entity)data.entity))).insertTo(group);
            OnPlayerInteract.listen(this::blockSleep).addCondition(Condition.hasEnchantment(this.enchantment, data -> data.player)).addCondition(Condition.isServer()).addCondition(Condition.predicate(Handler::isBed)).insertTo(group);
        }

        private void applyDebuffs(OnEntityTick.Data data) {
            assert (data.entity != null);
            int enchantmentSum = this.enchantment.get().getEnchantmentSum(data.entity, EquipmentSlots.ARMOR);
            this.setOnFire(enchantmentSum, data.entity);
            this.applyEffects(enchantmentSum, data.entity);
        }

        private void setOnFire(int enchantmentSum, LivingEntity entity) {
            entity.m_20254_((int)((Double)this.fireDuration.get() * (double)enchantmentSum));
        }

        private void applyEffects(int enchantmentSum, LivingEntity entity) {
            int extraAmplifier = this.scalesWithLevel.isEnabled() ? enchantmentSum - 1 : 0;
            this.weakness.apply(entity, extraAmplifier, 0);
            this.hunger.apply(entity, extraAmplifier, 0);
        }

        private void spawnParticles(OnEntityTick.Data data) {
            Vec3 position = AnyPos.from((Vec3)data.entity.m_20182_()).add((Number)0.0, (Number)((double)data.entity.m_20206_() * 0.5), (Number)0.0).vec3();
            ParticleHandler.SMOKE.spawn(data.getServerLevel(), position, 10, () -> new Vec3(0.25, 0.5, 0.25));
        }

        private void blockSleep(OnPlayerInteract.Data data) {
            data.event.setCancellationResult(InteractionResult.FAIL);
            data.event.setCanceled(true);
            data.player.m_5661_((Component)Component.m_237115_((String)"enchantment.majruszsenchantments.vampirism_curse.block_sleep"), true);
        }

        private static boolean isBed(OnPlayerInteract.Data data) {
            PlayerInteractEvent playerInteractEvent = data.event;
            if (playerInteractEvent instanceof PlayerInteractEvent.RightClickBlock) {
                PlayerInteractEvent.RightClickBlock event = (PlayerInteractEvent.RightClickBlock)playerInteractEvent;
                BlockPos position = event.getHitVec().m_82425_();
                return data.getLevel().m_8055_(position).isBed((BlockGetter)data.getLevel(), position, (LivingEntity)data.player);
            }
            return false;
        }
    }
}

